# Save Backup Copy of Database
# Copyright 2007 by Brian C. Christensen

"""
Make a backup copy of the database, add time stamp to name
"""

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 070301 - first version

import os, datetime

def SaveData(path=None):
    save_state = Data.ChangedData

    dateobj = datetime.datetime.today()
    ts = dateobj.strftime(" %Y-%m-%d %H-%M-%S.ganttpv")

    if path.endswith('.ganttpv'):
        path = path[:-len('.ganttpv')]
    path += ts

    Data.SaveContents(path)

    Data.ChangedData = save_state

if not Data.FileName:
    Menu.doSaveAs(1)

if Data.FileName:
    SaveData(Data.FileName)
